/***********************************************************************/
/*                                                                     */
/*  FILE        :interrupt_handlers.h                                  */
/*  DATE        :Mon, Aug 16, 2021                                     */
/*  DESCRIPTION :Interrupt Handler Declarations                        */
/*  CPU TYPE    :SH7267                                                */
/*                                                                     */
/*  This file is generated by KPIT GNU Project Generator.              */
/*  2021/8/16 ύX Aone  for AH8000	 M.Hasegawa                        */
/***********************************************************************/

#ifndef INTERRUPT_HANDLERS_H
#define INTERRUPT_HANDLERS_H

//*******************************************************
//   WX^[oNΉ
//   2021/8/16 ύX Aone  for AH8000	 M.Hasegawa 
//*******************************************************
#if (_RESBANK == 1)                           
	#define INT_RESBANK_DEFINE(isr) void isr(void) __attribute__ ((interrupt_handler,resbank));            
#else
	#define INT_RESBANK_DEFINE(isr) void isr(void) __attribute__ ((interrupt_handler));
#endif

//*******************************************************


//<<VECTOR DATA START (POWER ON RESET)>>
// ;0 Power On Reset PC                                                                                                            

// ;<<VECTOR DATA END (POWER ON RESET)>>
// 1 Power On Reset SP

//;<<VECTOR DATA START (MANUAL RESET)>>
//;2 Manual Reset PC
void INT_Manual_Reset_PC(void) __attribute__ ((interrupt_handler));

//;<<VECTOR DATA END (MANUAL RESET)>>
// 3 Manual Reset SP
void INT_Manual_Reset_SP(void) __attribute__ ((interrupt_handler));

// 4 Illegal code

void INT_Illegal_code(void) __attribute__ ((interrupt_handler));

// 5 Reserved

// 6 Illegal slot
void INT_Illegal_slot(void) __attribute__ ((interrupt_handler));

// 7 Reserved

// 8 Reserved

// 9 CPU Address error
void INT_CPU_Address(void) __attribute__ ((interrupt_handler));

// 10 BUS error
void INT_DMAC_Address(void) __attribute__ ((interrupt_handler));

// 11 NMI
void INT_NMI(void) __attribute__ ((interrupt_handler));

// 12 Reserved

// 13 INT_FPU
void INT_FPU(void) __attribute__ ((interrupt_handler));

// 14 H-UDI
void INT_HUDI(void) __attribute__ ((interrupt_handler));

// 15 Bank Overflow
void INT_Bank_Overflow(void) __attribute__ ((interrupt_handler));

// 16 Bank Underflow
void INT_Bank_Underflow(void) __attribute__ ((interrupt_handler));

// 17 Divide by zero
void INT_Divide_by_Zero(void) __attribute__ ((interrupt_handler));

// 18 Divide Overflow
void INT_Divide_Overflow(void) __attribute__ ((interrupt_handler));

// 19 Reserved

// 20 Reserved

// 21 Reserved

// 22 Reserved

// 23 Reserved

// 24 Reserved

// 25 Reserved

// 26 Reserved

// 27 Reserved

// 28 Reserved

// 29 Reserved

// 30 Reserved

// 31 Reserved

// 32 TRAPA (User Vecter)
void INT_TRAPA32(void) __attribute__ ((interrupt_handler));

// 33 TRAPA (User Vecter)
void INT_TRAPA33(void) __attribute__ ((interrupt_handler));

// 34 TRAPA (User Vecter)
void INT_TRAPA34(void) __attribute__ ((interrupt_handler));

// 35 TRAPA (User Vecter)
void INT_TRAPA35(void) __attribute__ ((interrupt_handler));

// 36 TRAPA (User Vecter)
void INT_TRAPA36(void) __attribute__ ((interrupt_handler));

// 37 TRAPA (User Vecter)
void INT_TRAPA37(void) __attribute__ ((interrupt_handler));

// 38 TRAPA (User Vecter)
void INT_TRAPA38(void) __attribute__ ((interrupt_handler));

// 39 TRAPA (User Vecter)
void INT_TRAPA39(void) __attribute__ ((interrupt_handler));

// 40 TRAPA (User Vecter)
void INT_TRAPA40(void) __attribute__ ((interrupt_handler));

// 41 TRAPA (User Vecter)
void INT_TRAPA41(void) __attribute__ ((interrupt_handler));

// 42 TRAPA (User Vecter)
void INT_TRAPA42(void) __attribute__ ((interrupt_handler));

// 43 TRAPA (User Vecter)
void INT_TRAPA43(void) __attribute__ ((interrupt_handler));

// 44 TRAPA (User Vecter)
void INT_TRAPA44(void) __attribute__ ((interrupt_handler));

// 45 TRAPA (User Vecter)
void INT_TRAPA45(void) __attribute__ ((interrupt_handler));

// 46 TRAPA (User Vecter)
void INT_TRAPA46(void) __attribute__ ((interrupt_handler));

// 47 TRAPA (User Vecter)
void INT_TRAPA47(void) __attribute__ ((interrupt_handler));

// 48 TRAPA (User Vecter)
void INT_TRAPA48(void) __attribute__ ((interrupt_handler));

// 49 TRAPA (User Vecter)
void INT_TRAPA49(void) __attribute__ ((interrupt_handler));

// 50 TRAPA (User Vecter)
void INT_TRAPA50(void) __attribute__ ((interrupt_handler));

// 51 TRAPA (User Vecter)
void INT_TRAPA51(void) __attribute__ ((interrupt_handler));

// 52 TRAPA (User Vecter)
void INT_TRAPA52(void) __attribute__ ((interrupt_handler));

// 53 TRAPA (User Vecter)
void INT_TRAPA53(void) __attribute__ ((interrupt_handler));

// 54 TRAPA (User Vecter)
void INT_TRAPA54(void) __attribute__ ((interrupt_handler));

// 55 TRAPA (User Vecter)
void INT_TRAPA55(void) __attribute__ ((interrupt_handler));

// 56 TRAPA (User Vecter)
void INT_TRAPA56(void) __attribute__ ((interrupt_handler));

// 57 TRAPA (User Vecter)
void INT_TRAPA57(void) __attribute__ ((interrupt_handler));

// 58 TRAPA (User Vecter)
void INT_TRAPA58(void) __attribute__ ((interrupt_handler));

// 59 TRAPA (User Vecter)
void INT_TRAPA59(void) __attribute__ ((interrupt_handler));

// 60 TRAPA (User Vecter)
void INT_TRAPA60(void) __attribute__ ((interrupt_handler));

// 61 TRAPA (User Vecter)
void INT_TRAPA61(void) __attribute__ ((interrupt_handler));

// 62 TRAPA (User Vecter)
void INT_TRAPA62(void) __attribute__ ((interrupt_handler));

// 63 TRAPA (User Vecter)
void INT_TRAPA63(void) __attribute__ ((interrupt_handler));

// 64 Interrupt IRQ0
INT_RESBANK_DEFINE(INT_IRQ_IRQ0)

// 65 Interrupt IRQ1
INT_RESBANK_DEFINE(INT_IRQ_IRQ1)

// 66 Interrupt IRQ2
INT_RESBANK_DEFINE(INT_IRQ_IRQ2)

// 67 Interrupt IRQ3
INT_RESBANK_DEFINE(INT_IRQ_IRQ3)

// 68 Interrupt IRQ4
INT_RESBANK_DEFINE(INT_IRQ_IRQ4)

// 69 Interrupt IRQ5
INT_RESBANK_DEFINE(INT_IRQ_IRQ5)

// 70 Interrupt IRQ6
INT_RESBANK_DEFINE(INT_IRQ_IRQ6)

// 71 Interrupt IRQ7
INT_RESBANK_DEFINE(INT_IRQ_IRQ7)

// 72 Reserved

// 73 Reserved

// 74 Reserved

// 75 Reserved

// 76 Reserved

// 77 Reserved

// 78 Reserved

// 79 Reserved

// 80 Interrupt PINT0
INT_RESBANK_DEFINE(INT_PINT_PINT0)

// 81 Interrupt PINT1
INT_RESBANK_DEFINE(INT_PINT_PINT1)

// 82 Interrupt PINT2
INT_RESBANK_DEFINE(INT_PINT_PINT2)

// 83 Interrupt PINT3
INT_RESBANK_DEFINE(INT_PINT_PINT3)

// 84 Interrupt PINT4
INT_RESBANK_DEFINE(INT_PINT_PINT4)

// 85 Interrupt PINT5
INT_RESBANK_DEFINE(INT_PINT_PINT5)

// 86 Interrupt PINT6
INT_RESBANK_DEFINE(INT_PINT_PINT6)

// 87 Interrupt PINT7
INT_RESBANK_DEFINE(INT_PINT_PINT7)

// 88 Reserved

// 89 Reserved

// 90 Reserved

// 91 Reserved

// 92 Reserved

// 93 Reserved

// 94 Reserved

// 95 Reserved

// 96 Reserved

// 97 Reserved

// 98 Reserved

// 99 Reserved

// 100 Reserved

// 101 Reserved

// 102 Reserved

// 103 Reserved

// 104 Reserved

// 105 Reserved

// 106 Reserved

// 107 Reserved

// 108 DMAC0 DEI0
INT_RESBANK_DEFINE(INT_DMAC0_DEI0)

// 109 DMAC0 HEI0
INT_RESBANK_DEFINE(INT_DMAC0_HEI0);

// 110 Reserved

// 111 Reserved

// 112 DMAC1 DEI1
INT_RESBANK_DEFINE(INT_DMAC1_DEI1)

// 113 DMAC1 HEI1
INT_RESBANK_DEFINE(INT_DMAC1_HEI1)

// 114 Reserved

// 115 Reserved

// 116 DMAC2 DEI2
INT_RESBANK_DEFINE(INT_DMAC2_DEI2)

// 117 DMAC2 HEI2
INT_RESBANK_DEFINE(INT_DMAC2_HEI2)

// 118 Reserved

// 119 Reserved

// 120 DMAC3 DEI3
INT_RESBANK_DEFINE(INT_DMAC3_DEI3)

// 121 DMAC3 HEI3
INT_RESBANK_DEFINE(INT_DMAC3_HEI3)

// 122 Reserved

// 123 Reserved

// 124 DMAC4 DEI4
INT_RESBANK_DEFINE(INT_DMAC4_DEI4)

// 125 DMAC4 HEI4
INT_RESBANK_DEFINE(INT_DMAC4_HEI4)

// 126 Reserved

// 127 Reserved

// 128 DMAC5 DEI5
INT_RESBANK_DEFINE(INT_DMAC5_DEI5)

// 129 DMAC5 HEI5
INT_RESBANK_DEFINE(INT_DMAC5_HEI5)

// 130 Reserved

// 131 Reserved

// 132 DMAC6 DEI6
INT_RESBANK_DEFINE(INT_DMAC6_DEI6)

// 133 DMAC6 HEI6
INT_RESBANK_DEFINE(INT_DMAC6_HEI6)

// 134 Reserved

// 135 Reserved

// 136 DMAC7 DEI7
INT_RESBANK_DEFINE(INT_DMAC7_DEI7)

// 137 DMAC7 HEI7
INT_RESBANK_DEFINE(INT_DMAC7_HEI7)

// 138 Reserved

// 139 Reserved

// 140 DMAC8 DEI8
INT_RESBANK_DEFINE(INT_DMAC8_DEI8)

// 141 DMAC8 HEI8
INT_RESBANK_DEFINE(INT_DMAC8_HEI8)

// 142 Reserved

// 143 Reserved

// 144 DMAC9 DEI9
INT_RESBANK_DEFINE(INT_DMAC9_DEI9)

// 145 DMAC9 HEI9
INT_RESBANK_DEFINE(INT_DMAC9_HEI9)

// 146 Reserved

// 147 Reserved

// 148 DMAC10 DEI10
INT_RESBANK_DEFINE(INT_DMAC10_DEI10)

// 149 DMAC10 HEI10
INT_RESBANK_DEFINE(INT_DMAC10_HEI10)

// 150 Reserved

// 151 Reserved

// 152 DMAC11 DEI11
INT_RESBANK_DEFINE(INT_DMAC11_DEI11)

// 153 DMAC11 HEI11
INT_RESBANK_DEFINE(INT_DMAC11_HEI11)

// 154 Reserved

// 155 Reserved

// 156 DMAC12 DEI12
INT_RESBANK_DEFINE(INT_DMAC12_DEI12)

// 157 DMAC12 HEI12
INT_RESBANK_DEFINE(INT_DMAC12_HEI12)

// 158 Reserved

// 159 Reserved

// 160 DMAC13 DEI13
INT_RESBANK_DEFINE(INT_DMAC13_DEI13)

// 161 DMAC13 HEI13
INT_RESBANK_DEFINE(INT_DMAC13_HEI13)

// 162 Reserved

// 163 Reserved

// 164 DMAC14 DEI14
INT_RESBANK_DEFINE(INT_DMAC14_DEI14)

// 165 DMAC14 HEI14
INT_RESBANK_DEFINE(INT_DMAC14_HEI14)

// 166 Reserved

// 167 Reserved

// 168 DMAC15 DEI15
INT_RESBANK_DEFINE(INT_DMAC15_DEI15)

// 169 DMAC15 HEI15
INT_RESBANK_DEFINE(INT_DMAC15_HEI15)

// 170 USB USBI
INT_RESBANK_DEFINE(INT_USB_USBI)

// 171 VDC3 VIVSYNCJ
INT_RESBANK_DEFINE(INT_VDC3_VIVSYNCJ)

// 172 VDC3 VBUFERRJ
INT_RESBANK_DEFINE(INT_VDC3_VBUFERR)

// 173 VDC3 VIFIELDE
INT_RESBANK_DEFINE(INT_VDC3_VIFIELDE)

// 174 VDC3 VOLINE
INT_RESBANK_DEFINE(INT_VDC3_VOLINE)

// 175 CMT CMT0 CMI0
INT_RESBANK_DEFINE(INT_CMT0_CMI0)

// 176 CMT CMT1 CMI1
INT_RESBANK_DEFINE(INT_CMT1_CMI1)

// 177 BSC CMI
INT_RESBANK_DEFINE(INT_BSC_CMI)

// 178 WDT
INT_RESBANK_DEFINE(INT_WDT_ITI)

// 179 MTU2 MTU0 TGI0A
INT_RESBANK_DEFINE(INT_MTU2_TGI0A)

// 180 MTU2 MTU0 TGI0B
INT_RESBANK_DEFINE(INT_MTU2_TGI0B)

// 181 MTU2 MTU0 TGI0C
INT_RESBANK_DEFINE(INT_MTU2_TGI0C)

// 182 MTU2 MTU0 TGI0D
INT_RESBANK_DEFINE(INT_MTU2_TGI0D)

// 183 MTU2 MTU0 TCI0V
INT_RESBANK_DEFINE(INT_MTU2_TCI0V)

// 184 MTU2 MTU0 TGI0E
INT_RESBANK_DEFINE(INT_MTU2_TGI0E)

// 185 MTU2 MTU0 TGI0F
INT_RESBANK_DEFINE(INT_MTU2_TGI0F)

// 186 MTU2 MTU1 TGI1A
INT_RESBANK_DEFINE(INT_MTU2_TGI1A)

// 187 MTU2 MTU1 TGI1B
INT_RESBANK_DEFINE(INT_MTU2_TGI1B)

// 188 MTU2 MTU1 TCI1V
INT_RESBANK_DEFINE(INT_MTU2_TCI1V)

// 189 MTU2 MTU1 TCI1U
INT_RESBANK_DEFINE(INT_MTU2_TCI1U)

// 190 MTU2 MTU2 TGI2A
INT_RESBANK_DEFINE(INT_MTU2_TGI2A)

// 191 MTU2 MTU2 TGI2B
INT_RESBANK_DEFINE(INT_MTU2_TGI2B)

// 192 MTU2 MTU2 TCI2V
INT_RESBANK_DEFINE(INT_MTU2_TCI2V)

// 193 MTU2 MTU2 TCI2U
INT_RESBANK_DEFINE(INT_MTU2_TCI2U)

// 194 MTU2 MTU3 TGI3A
INT_RESBANK_DEFINE(INT_MTU2_TGI3A)

// 195 MTU2 MTU3 TGI3B
INT_RESBANK_DEFINE(INT_MTU2_TGI3B)

// 196 MTU2 MTU3 TGI3C
INT_RESBANK_DEFINE(INT_MTU2_TGI3C)

// 197 MTU2 MTU3 TGI3D
INT_RESBANK_DEFINE(INT_MTU2_TGI3D)

// 198 MTU2 MTU3 TCI3V
INT_RESBANK_DEFINE(INT_MTU2_TCI3V)

// 199 MTU2 MTU4 TGI4A
INT_RESBANK_DEFINE(INT_MTU2_TGI4A)

// 200 MTU2 MTU4 TGI4B
INT_RESBANK_DEFINE(INT_MTU2_TGI4B)

// 201 MTU2 MTU4 TGI4C
INT_RESBANK_DEFINE(INT_MTU2_TGI4C)

// 202 MTU2 MTU4 TGI4D
INT_RESBANK_DEFINE(INT_MTU2_TGI4D)

// 203 MTU2 MTU4 TCI4V
INT_RESBANK_DEFINE(INT_MTU2_TCI4V)

// 204 PWM PWM1 
INT_RESBANK_DEFINE(INT_PWM1)

// 205 PWM PWM2
INT_RESBANK_DEFINE(INT_PWM2)

// 206 A/D ADI
INT_RESBANK_DEFINE(INT_AD_ADI)

// 207 SSI0 SSIF0
INT_RESBANK_DEFINE(INT_SSI0_SSIF0)

// 208 SSI0 SSIRXI0
INT_RESBANK_DEFINE(INT_SSI0_SSIRXI0)

// 209 SSI0 SSITXI0
INT_RESBANK_DEFINE(INT_SSI0_SSITXI0)

// 210 SSI1 SSII1
INT_RESBANK_DEFINE(INT_SSI1_SSII1)

// 211 SSI1 SSIRTI1
INT_RESBANK_DEFINE(INT_SSI1_SSIRTI1)

// 212 SSI2 SSII2
INT_RESBANK_DEFINE(INT_SSI2_SSII2)

// 213 SSI2 SSIRTI2
INT_RESBANK_DEFINE(INT_SSI2_SSIRTI2)

// 214 SSI3 SSII3
INT_RESBANK_DEFINE(INT_SSI3_SSII3)

// 215 SSI3 SSIRTI3
INT_RESBANK_DEFINE(INT_SSI3_SSIRTI3)

// 216 SPDIF SPDIFI
INT_RESBANK_DEFINE(INT_SPDIF_SPDIFI)

// 217 IIC3 IIC0 STPI0
INT_RESBANK_DEFINE(INT_IIC3_STPI0)

// 218 IIC3 IIC0 NAKI0
INT_RESBANK_DEFINE(INT_IIC3_NAKI0)

// 219 IIC3 IIC0 RXI0
INT_RESBANK_DEFINE(INT_IIC3_RXI0) 

// 220 IIC3 IIC0 TXI0
INT_RESBANK_DEFINE(INT_IIC3_TXI0) 

// 221 IIC3 IIC0 TEI0
INT_RESBANK_DEFINE(INT_IIC3_TEI0) 

// 222 IIC3 IIC1 STPI1
INT_RESBANK_DEFINE(INT_IIC3_STPI1)

// 223 IIC3 IIC1 NAKI1
INT_RESBANK_DEFINE(INT_IIC3_NAKI1)

// 224 IIC3 IIC1 RXI1
INT_RESBANK_DEFINE(INT_IIC3_RXI1) 

// 225 IIC3 IIC1 TXI1
INT_RESBANK_DEFINE(INT_IIC3_TXI1) 

// 226 IIC3 IIC1 TEI1
INT_RESBANK_DEFINE(INT_IIC3_TEI1) 

// 227 IIC3 IIC2 STPI2
INT_RESBANK_DEFINE(INT_IIC3_STPI2)

// 228 IIC3 IIC2 NAKI2
INT_RESBANK_DEFINE(INT_IIC3_NAKI2)

// 229 IIC3 IIC2 RXI2
INT_RESBANK_DEFINE(INT_IIC3_RXI2) 

// 230 IIC3 IIC2 TXI2
INT_RESBANK_DEFINE(INT_IIC3_TXI2) 

// 231 IIC3 IIC2 TEI2
INT_RESBANK_DEFINE(INT_IIC3_TEI2) 

// 232 SCIF SCIF0 BRI0
INT_RESBANK_DEFINE(INT_SCIF0_BRI0)

// 233 SCIF SCIF0 ERI0
INT_RESBANK_DEFINE(INT_SCIF0_ERI0)

// 234 SCIF SCIF0 RXI0
INT_RESBANK_DEFINE(INT_SCIF0_RXI0)

// 235 SCIF SCIF0 TXI0
INT_RESBANK_DEFINE(INT_SCIF0_TXI0)

// 236 SCIF SCIF1 BRI1
INT_RESBANK_DEFINE(INT_SCIF1_BRI1)

// 237 SCIF SCIF1 ERI1
INT_RESBANK_DEFINE(INT_SCIF1_ERI1)

// 238 SCIF SCIF1 RXI1
INT_RESBANK_DEFINE(INT_SCIF1_RXI1)

// 239 SCIF SCIF1 TXI1
INT_RESBANK_DEFINE(INT_SCIF1_TXI1)

// 240 SCIF SCIF2 BRI2
INT_RESBANK_DEFINE(INT_SCIF2_BRI2)

// 241 SCIF SCIF2 ERI2
INT_RESBANK_DEFINE(INT_SCIF2_ERI2)

// 242 SCIF SCIF2 RXI2
INT_RESBANK_DEFINE(INT_SCIF2_RXI2)

// 243 SCIF SCIF2 TXI2
INT_RESBANK_DEFINE(INT_SCIF2_TXI2)

// 244 SCIF SCIF3 BRI3
INT_RESBANK_DEFINE(INT_SCIF3_BRI3)

// 245 SCIF SCIF3 ERI3
INT_RESBANK_DEFINE(INT_SCIF3_ERI3)

// 246 SCIF SCIF3 RXI3
INT_RESBANK_DEFINE(INT_SCIF3_RXI3)

// 247 SCIF SCIF3 TXI3
INT_RESBANK_DEFINE(INT_SCIF3_TXI3)

// 248 SCIF SCIF4 BRI4
INT_RESBANK_DEFINE(INT_SCIF4_BRI4)

// 249 SCIF SCIF4 ERI4
INT_RESBANK_DEFINE(INT_SCIF4_ERI4)

// 250 SCIF SCIF4 RXI4
INT_RESBANK_DEFINE(INT_SCIF4_RXI4)

// 251 SCIF SCIF4 TXI4
INT_RESBANK_DEFINE(INT_SCIF4_TXI4)

// 252 SCIF SCIF5 BRI5
INT_RESBANK_DEFINE(INT_SCIF5_BRI5)

// 253 SCIF SCIF5 ERI5
INT_RESBANK_DEFINE(INT_SCIF5_ERI5)

// 254 SCIF SCIF5 RXI5
INT_RESBANK_DEFINE(INT_SCIF5_RXI5)

// 255 SCIF SCIF5 TXI5
INT_RESBANK_DEFINE(INT_SCIF5_TXI5)

// 256 SCIF SCIF6 BRI6
INT_RESBANK_DEFINE(INT_SCIF6_BRI6)

// 257 SCIF SCIF6 ERI6
INT_RESBANK_DEFINE(INT_SCIF6_ERI6)

// 258 SCIF SCIF6 RXI6
INT_RESBANK_DEFINE(INT_SCIF6_RXI6)

// 259 SCIF SCIF6 TXI6
INT_RESBANK_DEFINE(INT_SCIF6_TXI6)

// 260 SCIF SCIF7 BRI7
INT_RESBANK_DEFINE(INT_SCIF7_BRI7)

// 261 SCIF SCIF7 ERI7
INT_RESBANK_DEFINE(INT_SCIF7_ERI7)

// 262 SCIF SCIF7 RXI7
INT_RESBANK_DEFINE(INT_SCIF7_RXI7)

// 263 SCIF SCIF7 TXI7
INT_RESBANK_DEFINE(INT_SCIF7_TXI7)

// 264 SIOF SIOFI
INT_RESBANK_DEFINE(INT_SIOF_SIOFI)

// 265 RSPI RSPI0 SPEI0
INT_RESBANK_DEFINE(INT_RSPI0_SPEI0)

// 266 RSPI RSPI0 SPRI0
INT_RESBANK_DEFINE(INT_RSPI0_SPRI0)

// 267 RSPI RSPI0 SPTI0
INT_RESBANK_DEFINE(INT_RSPI0_SPTI0)

// 268 RSPI RSPI1 SPEI1
INT_RESBANK_DEFINE(INT_RSPI1_SPEI1)

// 269 RSPI RSPI1 SPRI1
INT_RESBANK_DEFINE(INT_RSPI1_SPRI1)

// 270 RSPI RSPI1 SPTI1
INT_RESBANK_DEFINE(INT_RSPI1_SPTI1)

// 271 RCAN RCAN0 ERS0 
INT_RESBANK_DEFINE(INT_RCAN0_ERS0) 

// 272 RCAN RCAN0 OVR0 
INT_RESBANK_DEFINE(INT_RCAN0_OVR0) 

// 273 RCAN RCAN0 RM00 
INT_RESBANK_DEFINE(INT_RCAN0_RM00) 

// 274 RCAN RCAN0 RM10 
INT_RESBANK_DEFINE(INT_RCAN0_RM10) 

// 275 RCAN RCAN0 SLE0 
INT_RESBANK_DEFINE(INT_RCAN0_SLE0) 

// 276 RCAN RCAN1 ERS1 
INT_RESBANK_DEFINE(INT_RCAN1_ERS1) 

// 277 RCAN RCAN1 OVR1 
INT_RESBANK_DEFINE(INT_RCAN1_OVR1) 

// 278 RCAN RCAN1 RM01 
INT_RESBANK_DEFINE(INT_RCAN1_RM01) 

// 279 RCAN RCAN1 RM11 
INT_RESBANK_DEFINE(INT_RCAN1_RM11) 

// 280 RCAN RCAN1 SLE1 
INT_RESBANK_DEFINE(INT_RCAN1_SLE1) 

// 281 IEB IEB 
INT_RESBANK_DEFINE(INT_IEB_IEB) 

// 282 ROMDEC ISY 
INT_RESBANK_DEFINE(INT_ROMDEC_ISY)

// 283 ROMDEC IERR 
INT_RESBANK_DEFINE(INT_ROMDEC_IERR)

// 284 ROMDEC ITARG 
INT_RESBANK_DEFINE(INT_ROMDEC_ITARG)

// 285 ROMDEC ISEC 
INT_RESBANK_DEFINE(INT_ROMDEC_ISEC) 

// 286 ROMDEC IBUF 
INT_RESBANK_DEFINE(INT_ROMDEC_IBUF)

// 287 ROMDEC IREADY 
INT_RESBANK_DEFINE(INT_ROMDEC_IREADY)

// 288 FLCTL FLSTEI 
INT_RESBANK_DEFINE(INT_FLCTL_FLSTEI)

// 289 FLCTL FLTENDI 
INT_RESBANK_DEFINE(INT_FLCTL_FLTENDI)

// 290 FLCTL FLTREQ0I 
INT_RESBANK_DEFINE(INT_FLCTL_FLTREQ0I)

// 291 FLCTL FLTREQ1I 
INT_RESBANK_DEFINE(INT_FLCTL_FLTREQ1I)

// 292 SDHI SDHI3 
INT_RESBANK_DEFINE(INT_SDHI_SDHI3)

// 293 SDHI SDHI0 
INT_RESBANK_DEFINE(INT_SDHI_SDHI0)

// 294 SDHI SDHI1 
INT_RESBANK_DEFINE(INT_SDHI_SDHI1)

// 295 Reserved

// 296 RTC ARM 
INT_RESBANK_DEFINE(INT_RTC_ARM)

// 297 RTC PRD 
INT_RESBANK_DEFINE(INT_RTC_PRD)

// 298 RTC CUP 
INT_RESBANK_DEFINE(INT_RTC_CUP)

// 299 SRC SRC0 OVF0 
INT_RESBANK_DEFINE(INT_SRC0_OVF0)

// 300 SRC SRC0 UDF0 
INT_RESBANK_DEFINE(INT_SRC0_UDF0)

// 301 SRC SRC0 CEF0 
INT_RESBANK_DEFINE(INT_SRC0_CEF0)

// 302 SRC SRC0 ODFI0 
INT_RESBANK_DEFINE(INT_SRC0_ODFI0)

// 303 SRC SRC0 IDEI0 
INT_RESBANK_DEFINE(INT_SRC0_IDEI0)

// 304 SRC SRC1 OVF1 
INT_RESBANK_DEFINE(INT_SRC1_OVF1) 

// 305 SRC SRC1 UDF1 
INT_RESBANK_DEFINE(INT_SRC1_UDF1) 

// 306 SRC SRC1 CEF1 
INT_RESBANK_DEFINE(INT_SRC1_CEF1) 

// 307 SRC SRC1 ODFI1 
INT_RESBANK_DEFINE(INT_SRC1_ODFI1)

// 308 SRC SRC1 IDEI1 
INT_RESBANK_DEFINE(INT_SRC1_IDEI1)

// 309 Reserved

// 310 Reserved  Aone  for AH8000

// 311 Reserved  Aone  for AH8000

// 312 Reserved  Aone  for AH8000

// 313  Reserved Aone  for AH8000

// 314 RQSPI SPRI Aone  for AH8000
INT_RESBANK_DEFINE(INT_RQSPI_SPRI)

// 315 RQSPI SPTI Aone  for AH8000
INT_RESBANK_DEFINE(INT_RQSPI_SPTI)

#endif 
/* End of File */
