/*------------------------------------------------------------------------
                                                                       |
   FILE        : reset_program.s                                       |
   DATE        : Mon, Jun 14, 2021                                     |
   DESCRIPTION : Reset Program                                         |
   CPU TYPE    : SH7267                                                |
                                                                       |
   This file is generated by KPIT GNU Project Generator (Ver.4.5).     |
   2021/8/16 ύX Aone  for AH8000	 M.Hasegawa                        |
------------------------------------------------------------------------*/
                        


	! reset_program.s

	.list
	.section .text
	.global _PowerON_Reset  ! global Start routine 


	.extern _HardwareSetup ! external Sub-routine to initialise Hardware
	.extern _data
	.extern _mdata
	.extern _ebss
	.extern _bss
	.extern _edata
	.extern _main 
	.extern _stack
	.extern _vects

_PowerON_Reset :
	! initialise the SP for non-vectored code
	mov.l	stack,r15


! Call HardwareSetup
	mov.l	HardwareSetup,r1
	jsr     @r1
	nop
	
!load data section from ROM to RAM  

! initialise sections
	mov.l	edata,r1		! edata in r1
	mov.l	mdata,r2		! mdata in r2
	mov.l	data,r0		    ! data in r0
	cmp/eq  r0,r1
	bt	start_1
	nop
start_l:
	mov.b   @r2,r3  !get from src
	mov.b   r3,@r0  !place in dest
	add   	#1,r2    !inc src
	add   	#1,r0    !inc dest
	cmp/eq  r0,r1   !dest == edata?
	bf	start_l
	nop
start_1:

	! zero out bss
	mov.l	ebss,r1
	mov.l	bss,r0
	cmp/eq	r0,r1         
	bt	start_3
	sub	r2,r2
start_2:
	mov.b	r2,@r0
	add	#1,r0
	cmp/eq	r0,r1
	bf     	start_2
	nop
start_3:


#if !defined (__SH2A_NOFPU__)
#if defined (__SH2A__) || defined (__SH2E__) || defined (__SH3E__) || defined(__SH4_SINGLE__) ||defined(__SH4__) || defined(__SH4_SINGLE_ONLY__)
	mov.l set_fpscr_k, r1
	jsr @r1
	mov #0,r4
	lds r3,fpscr
	mov.l vects,r1		/* Aone  for AH8000 */
	ldc	r1,vbr			/* Aone  for AH8000 */
#endif // defined (__SH2A__) || defined (__SH2E__) || defined (__SH3E__) || defined(__SH4_SINGLE__) || defined(__SH4__) || defined(__SH4_SINGLE_ONLY__) 
#endif // !defined (__SH2A_NOFPU__)

	mov.l	main,r1
	jsr     @r1
	nop
	
	! call to exit

	.align 2
#if !defined (__SH2A_NOFPU__)
#if defined (__SH2A__) || defined (__SH2E__) || defined (__SH3E__) || defined(__SH4_SINGLE__) ||defined(__SH4__) || defined(__SH4_SINGLE_ONLY__)
set_fpscr_k:
		.long	___set_fpscr
#endif // defined (__SH2A__) || defined (__SH2E__) || defined (__SH3E__) || defined(__SH4_SINGLE__) || defined(__SH4__) || defined(__SH4_SINGLE_ONLY__) 
#endif // !defined (__SH2A_NOFPU__)


	.ALIGN 4
vects:
		.long	_vects	/* Aone  for AH8000 */
HardwareSetup:	
		.long	_HardwareSetup
data:
		.long	_data
mdata:
		.long	_mdata
edata:
		.long	_edata
bss:
		.long	_bss
ebss:
		.long	_ebss

stack:
		.long	_stack
main:
		.long	_main

	.end
